# バッチ設計書 5-Show task dialog.ps1

## 概要

本ドキュメントは、StaxRipアプリケーション内でタスクダイアログを表示し、ユーザーの選択を処理するサンプルPowerShellスクリプト「Show task dialog.ps1」の設計書です。

### 本バッチの処理概要

このスクリプトは、StaxRipアプリケーションのTaskDialogクラスを使用して、複数の選択肢を持つダイアログを表示し、ユーザーの選択結果に応じて異なるメッセージを表示するサンプルスクリプトです。

**業務上の目的・背景**：StaxRipのスクリプティングAPIには、単純なメッセージ表示以外にも、ユーザーとの対話的なインターフェースを提供する機能があります。このスクリプトは、TaskDialogクラスを使用したユーザー入力の取得方法を示すサンプルとして提供されています。開発者はこのパターンを応用して、設定の選択やワークフローの分岐などを実装できます。

**バッチの実行タイミング**：StaxRipアプリケーション内から手動で実行されます。スクリプトメニューから選択して実行します。

**主要な処理内容**：
1. TaskDialog[string]オブジェクトの作成とタイトル設定
2. 2つのコマンドオプション（Option A、Option B）の追加
3. ダイアログの表示とユーザー選択の取得
4. TaskDialogリソースの解放
5. 選択結果に応じたメッセージ表示（3パターン：A選択、B選択、未選択）

**前後の処理との関連**：独立したサンプルスクリプトであり、他のバッチや処理との依存関係はありません。

**影響範囲**：ユーザーインターフェースにダイアログを表示するのみで、ファイルやデータへの影響はありません。

## バッチ種別

サンプルスクリプト / デモンストレーション

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動（StaxRipアプリ内） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| StaxRipの実行 | StaxRipアプリケーションが起動していること |
| スクリプト実行環境 | StaxRipのPowerShellスクリプティング機能が有効であること |

### 実行可否判定

特別な条件なし。StaxRipが起動していれば常に実行可能です。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | スクリプトパラメータは受け付けません |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ユーザー入力 | GUIダイアログ選択 | Option A、Option B、またはキャンセル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| タスクダイアログ | GUIダイアログ | 選択肢を含むダイアログ |
| 結果メッセージ | GUIダイアログ | 選択結果に応じたメッセージ |

### 出力ファイル仕様

ファイル出力はありません。

## 処理フロー

### 処理シーケンス

```
1. TaskDialogオブジェクト作成
   └─ New-Object TaskDialog[string]でダイアログを初期化
2. タイトル設定
   └─ "Select a option."をダイアログタイトルに設定
3. コマンド追加
   └─ Option A（戻り値'aaa'）とOption B（戻り値'bbb'）を追加
4. ダイアログ表示
   └─ Show()メソッドでダイアログを表示し、選択結果を取得
5. リソース解放
   └─ Dispose()メソッドでTaskDialogを解放
6. 選択結果の判定と表示
   └─ 'aaa'の場合："Option A was selected."
   └─ 'bbb'の場合："Option B was selected."
   └─ それ以外："No option was selected."
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[TaskDialog作成]
    B --> C[タイトル設定]
    C --> D[Option A追加]
    D --> E[Option B追加]
    E --> F[ダイアログ表示]
    F --> G[Dispose実行]
    G --> H{選択結果判定}
    H -->|aaa| I[Option A選択メッセージ]
    H -->|bbb| J[Option B選択メッセージ]
    H -->|その他| K[未選択メッセージ]
    I --> L[スクリプト終了]
    J --> L
    K --> L
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作なし |

### テーブル別操作詳細

データベース操作は行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | スクリプトエラー | StaxRip外で実行した場合 | StaxRipアプリ内から実行する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

StaxRipのスクリプティング環境が正しく設定されているか確認してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の対話 |
| 目標処理時間 | ユーザー操作時間に依存 |
| メモリ使用量上限 | 最小限 |

## 排他制御

排他制御は不要です。モーダルダイアログのため、ダイアログ表示中は他の操作がブロックされます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| なし | - | ログ出力なし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | - | - |

## 備考

- TaskDialog[string]はジェネリック型で、string型の戻り値を持つダイアログを作成します
- AddCommand(表示テキスト, 戻り値)でコマンドボタンを追加します
- ユーザーがダイアログをキャンセルした場合（×ボタン等）、戻り値は'aaa'でも'bbb'でもないため、"No option was selected."が表示されます
- Dispose()でリソースを解放することが推奨されています
- このパターンは設定選択やワークフロー分岐に応用できます
